<?php

use CodeIgniter\Router\RouteCollection;
use App\Controllers\Home;

/**
 * @var RouteCollection $routes
 */

$routes->get('/login', 'Auth::index');
$routes->post('/login', 'Auth::login');
$routes->get('/logout', 'Auth::logout');
$routes->post('/recover', 'Auth::recover');
$routes->get('/recuperar-clave', 'Auth::recover');
$routes->get('/validar/(:any)', 'Auth::validarToken/$1');
$routes->post('/cambiar-clave', 'Auth::cambiarClave');
 
$routes->group('', ['filter' => 'auth'], function($routes){
   $routes->get('/', 'Home::index');

   $routes->get('usuario', 'Usuario::index');
   $routes->post('usuario/datatable', 'Usuario::datatable');
   $routes->get('usuario/create', 'Usuario::create');
   $routes->post('usuario/store', 'Usuario::store');
   $routes->get('usuario/edit/(:num)', 'Usuario::edit/$1');
   $routes->post('usuario/update/(:num)', 'Usuario::update/$1');
   $routes->get('usuario/delete/(:num)', 'Usuario::delete/$1');

   $routes->get('permisos', 'Permisos::index');
   $routes->get('permisos/perfil/(:num)', 'Permisos::index/$1');
   $routes->post('permisos/guardar/(:num)', 'Permisos::guardar/$1');

   $routes->get('mi-perfil', 'MiPerfil::index');
   $routes->post('mi-perfil/update', 'MiPerfil::update');
});