<?php
namespace App\Controllers;
use CodeIgniter\Exceptions\PageNotFoundException;
use App\Models\UsuarioModel;
use App\Models\RecuperacionModel;

class Auth extends BaseController
{
    protected $session;
    protected $usuarioModel;
    protected $recuperacionModel;

    public function __construct()
    {
        $this->session = session();
        $this->usuarioModel = new UsuarioModel();
        $this->recuperacionModel = new RecuperacionModel();
    }

    // Show login form
    public function index()
    {
        if ($this->session->get('isLoggedIn')) {
            return redirect()->to('/');
        }

        // Assumes a view at app/Views/auth/login.php
        return view('auth/login');
    }

    // Handle login POST
    public function login()
    {
        // Solo POST
       /* if ($this->request->getMethod() !== 'post') {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Método no permitido.'
            ]);
        }*/

        // Reglas de validación
        $rules = [
            'email'    => 'required|valid_email',
            'password' => 'required|min_length[4]',
        ];

        if (! $this->validate($rules)) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Hay errores en el formulario.',
                'errors'  => $this->validator->getErrors()
            ]);
        }

        $email    = $this->request->getPost('email');
        $password = $this->request->getPost('password');

        // Ejemplo (reemplazar por consulta al modelo)
        $login=$this->usuarioModel->loginUsuario($email, $password);

        if ($login!=null) {
            //$login=[];
            // Guarda sesión
            $this->session->set([
                'isLoggedIn' => true,
                'usuario'=>$login
            ]);

            return $this->response->setJSON([
                'success' => true,
                'message' => 'Inicio de sesión correcto.',
                'data' => [
                    'redirect' => base_url('/'),
                    'user' => $login
                ]
            ]);
        }

        // Credenciales inválidas
        return $this->response->setJSON([
            'success' => false,
            'message' => 'Credenciales inválidas.',
        ]);
    }

    public function recover(){
        if ($this->request->getPost()!=null) {
             // Reglas de validación
            $rules = [
                'email'    => 'required|valid_email'
            ];

            if (! $this->validate($rules)) {
                return $this->response->setJSON([
                    'success' => false,
                    'message' => 'Hay errores en el formulario.',
                    'errors'  => $this->validator->getErrors()
                ]);
            }
            $email    = $this->request->getPost('email');
            $existe=$this->usuarioModel->where('email',$email)->where('activo',1)->first();
            if($existe!=null){
                //Enviar correo con link de recuperación
                $usuario_id=$existe['id'];
                $idToken = $this->recuperacionModel->crearToken($usuario_id, $this->request->getIPAddress());
                $enviado = sendEmail(
                    $email,
                    'Recuperación de contraseña',
                    view('email/recuperar_clave', ['token' => $idToken])
                );
                return $this->response->setJSON([
                    'success' => true,
                    'message' => 'Se ha enviado un correo con las instrucciones para restablecer su contraseña.'
                ]);
            }else{
                return $this->response->setJSON([
                    'success' => false,
                    'message' => 'El correo ingresado es inválido.'
                ]);
            }
        }else{
            return view('auth/recover');
        }
    }

    public function cambiarClave(){
    
        $rules = [
                'token'    => 'required',
                'password'=> 'required|min_length[4]',
                'password2'=> 'required|matches[password]'
        ];

        if (!$rules) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Hay errores en el formulario.',
                'errors'  => $this->validator->getErrors()
            ]);
        }
        $token=$this->request->getPost('token');
       
        $tokenValido=$this->recuperacionModel->esTokenValido($token);
        if ($tokenValido) {
            $datos=$this->recuperacionModel->where('uuid',$token)->first();
            $usuario_id=$datos['usuario_id'];
            $usuario=[
                'password'=> password_hash($this->request->getPost('password'), PASSWORD_DEFAULT)
            ]; 
                
            $this->usuarioModel->update($usuario_id, $usuario);
            $this->recuperacionModel->update($datos['id'], ['fecha_uso'=>date('Y-m-d H:i:s')]);
            return $this->response->setJSON([
                'success' => true,
                'message' => 'Contraseña modificada correctamente.'
            ]);
                
        
        }else{
// Token inválido o expirado
            return $this->response->setJSON([
                'success' => false,
                'message' => 'El enlace de recuperación es inválido o ha expirado.'
            ]);
        }
    }

    public function validarToken($token=null){
    
        if ($token==null) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Hay errores en el formulario.',
                'errors'  => $this->validator->getErrors()
            ]);
        }
        
        if ($this->recuperacionModel->esTokenValido($token)) {
            return view('auth/reset_password', ['token' => $token]);
        } else {
            // Token inválido o expirado
            /*return $this->response->setJSON([
                'success' => false,
                'message' => 'El enlace de recuperación es inválido o ha expirado.'
            ]);*/
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
            
        }       
       
    }

    // Logout user
    public function logout()
    {
        $this->session->destroy();
        return redirect()->to('/login')->with('message', 'You have been logged out.');
    }
}