<?php 
    namespace App\Controllers;
    use CodeIgniter\Exceptions\PageNotFoundException;
    use App\Models\PerfilModel;
    use App\Models\PerfilPermisoModel;

    class Permisos extends BaseController
    {
        protected $perfilPermisoModel;
        protected $perfilModel;

        public function __construct()
        {
            $this->perfilPermisoModel = new PerfilPermisoModel();
            $this->perfilModel        = new PerfilModel(); // <- usa tabla perfil
        }

        public function index($perfil_id=null)
        {
            permiso('Permisos','Visualizar',true);
            if($perfil_id==null){
                 return view('permisos/perfiles', [
                    'perfiles'           => $this->perfilModel->findAll()
                ]);
            }else{
                $perfil = $this->perfilModel->find($perfil_id);
                if (!$perfil) {
                    return redirect()->back()->with('error', 'Perfil no encontrado.');
                }

                $permisos       = $this->perfilPermisoModel->getAllPermisos();
                $permisosActual = $this->perfilPermisoModel->getPermisosByPerfil($perfil_id);

                $permisosMarcados = [];
                foreach ($permisosActual as $p)
                    $permisosMarcados["{$p['modulo']}_{$p['accion']}"] = true;

                return view('permisos/perfil', [
                    'perfil'           => $perfil,
                    'permisos'         => $permisos,
                    'permisosMarcados' => $permisosMarcados
                ]);
            }
           
        }

        public function guardar($perfil_id)
        {
            $permisos = $this->request->getPost('permiso') ?? [];

            $this->perfilPermisoModel->savePermisosPerfil($perfil_id, $permisos);

            return redirect()->back()->with('success', 'Permisos actualizados correctamente.');
        }
    }

?>