<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\UsuarioModel;
use App\Models\PerfilModel;

class Usuario extends BaseController
{
    protected $usuarioModel;
    protected $perfilModel;


    public function __construct()
    {
        $this->usuarioModel = new UsuarioModel();
        $this->perfilModel = new PerfilModel();
    }

    public function index()
    {
        permiso('Usuario','Visualizar',true);
        $data['usuarios'] = $this->usuarioModel->findAll();
        return view('usuario/index', $data);
    }

    public function create()
    {
        permiso('Usuario','Crear',true);
        $data = [];
        $data['perfiles'] = $this->perfilModel->findAll();
        return view('usuario/create',$data);
    }

    public function store()
    {
        $data = $this->request->getPost();

        // password encriptado
        if (!empty($data['password'])) {
            $data['password'] = password_hash($data['password'], PASSWORD_DEFAULT);
        }

        $existeEmail = $this->usuarioModel->where('email', $data['email'])->where('deleted_at',null)->first();
        $existeRut = $this->usuarioModel->where('rut', $data['rut'])->where('deleted_at',null)->first();
        if ($existeEmail) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'El email ya está registrado.'
            ]);
            die();
        }
        if ($existeRut) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'El RUT ya está registrado.'
            ]);
            die();
        }

        $this->usuarioModel->save($data);

        return $this->response->setJSON([
                'success' => true,
                'message' => 'Usuario creado correctamente.',
                'data' => [
                    'user' => $data
                ]
            ]);
    }

    public function edit($id)
    {
        permiso('Usuario','Editar',true);
        $data['usuario'] = $this->usuarioModel->find($id);
        $data['perfiles'] = $this->perfilModel->findAll();
        return view('usuario/edit', $data);
    }

    public function update($id)
    {
        $data = $this->request->getPost();

        $existeEmail = $this->usuarioModel->where('email', $data['email'])->where('id !=',$id)->where('deleted_at',null)->first();
        $existeRut = $this->usuarioModel->where('rut', $data['rut'])->where('id !=',$id)->where('deleted_at',null)->first();
        
        if ($existeEmail) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'El email ya está registrado.'
            ]);
            die();
        }
        if ($existeRut) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'El RUT ya está registrado.'
            ]);
            die();
        }
        
        $usuario=[
            "email"=>$data['email'],
            "nombre"=>$data['nombre'],
            "rut"=>$data['rut'],
            "perfil_id"=>$data['perfil_id'],
            "activo"=>$data['activo'],

        ];

        if (!empty($data['password'])) {
            $data['password'] = password_hash($data['password'], PASSWORD_DEFAULT);
        }

        $this->usuarioModel->update($id, $usuario);

        return $this->response->setJSON([
                'success' => true,
                'message' => 'Usuario editado correctamente.',
                'data' => [
                    'user' => $data
                ]
            ]);
    }

    public function delete($id)
    {
        permiso('Usuario','Eliminar',true);
        $this->usuarioModel->delete($id);
        return redirect()->to('/usuario')->with('success', 'Usuario eliminado.');
    }

    public function datatable()
    {
        permiso('Usuario','Visualizar',true);
        $json = $this->usuarioModel->getDatatable($this->request);
        return $this->response->setJSON($json);
    }

}
