<?php

use CodeIgniter\Config\Services;

if (!function_exists('sendEmail')) {

    /**
     * Envía un correo usando la configuración de Email de CodeIgniter 4.
     *
     * @param string $to       Destinatario
     * @param string $subject  Asunto del correo
     * @param string $message  Contenido HTML del correo
     * @param array  $attachments  Archivos adjuntos (opcional)
     *
     * @return bool  true si se envió, false si ocurrió un error
     */
    function sendEmail(string $to, string $subject, string $message, array $attachments = [])
    {
        $email = Services::email();

        // Cargar configuración desde app/Config/Email.php
        $config = config('Email');
        $email->initialize($config);

        // Remitente (usa el configurado en Email.php)
        $email->setFrom($config->fromEmail, $config->fromName);

        $email->setTo($to);
        $email->setSubject($subject);
        $email->setMessage($message);

        // Adjuntos
        if (!empty($attachments)) {
            foreach ($attachments as $filePath) {
                if (file_exists($filePath)) {
                    $email->attach($filePath);
                }
            }
        }

        // Enviar
        try {
            return $email->send();
        } catch (\Exception $e) {
            log_message('error', 'Error al enviar correo: ' . $e->getMessage());
            return false;
        }
    }
}
