<?php

function permiso($modulo, $accion, $show_error = false)
{
    $session = session();

    if (!isset($session->usuario['perfil_id'])) 
        return false;

    $perfil_id = $session->usuario['perfil_id'];

    $db = \Config\Database::connect();

    $permiso = $db->table('perfil_permisos')
        ->select('perfil_permisos.id')
        ->join('permisos', 'permisos.id = perfil_permisos.permiso_id')
        ->where('perfil_permisos.perfil_id', $perfil_id)
        ->where('permisos.modulo', $modulo)
        ->where('permisos.accion', $accion)
        ->get()
        ->getRow();

    $tienePermiso = $permiso ? true : false;

    if (!$tienePermiso && $show_error) {
        echo view('errors/custom_403');
        exit;
    }

    return $tienePermiso;
}
