<?php namespace App\Models;

use CodeIgniter\Model;

class PerfilPermisoModel extends Model
{
    protected $table = 'perfil_permisos';
    protected $primaryKey = 'id';
    protected $allowedFields = ['perfil_id', 'permiso_id'];

    public function getPermisosByPerfil($perfil_id)
    {
        return $this->select('permisos.modulo, permisos.accion')
                    ->join('permisos', 'permisos.id = perfil_permisos.permiso_id')
                    ->where('perfil_permisos.perfil_id', $perfil_id)
                    ->findAll();
    }

    public function getAllPermisos()
    {
        return $this->db->table('permisos')->get()->getResultArray();
    }

    public function savePermisosPerfil($perfil_id, $permisos)
    {
        $this->where('perfil_id', $perfil_id)->delete();

        foreach ($permisos as $permiso_id) {
            $this->insert([
                'perfil_id'  => $perfil_id,
                'permiso_id' => $permiso_id
            ]);
        }
    }
}
