<?= $this->extend('layouts/master-auth') ?>

<?= $this->section('title') ?>
Modernize Bootstrap Admin
<?= $this->endSection() ?>

<?= $this->section('css') ?>
    <style>
        .btn-claveunica {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            background-color: #0F69C4;
            color: #FFFFFF;
            font-family: 'Roboto', sans-serif;
            font-weight: bold;
            font-size: 1rem;
            padding: 8px 14px;
            height: 48px;
            border: none;
            border-radius: 0;
            cursor: pointer;
            text-decoration: none;
            transition: background-color 0.2s ease, box-shadow 0.2s ease;
            width: 100%;
            text-align: center !important;
        } 

        .btn-claveunica img {
        width: 24px;
        height: 24px;
        margin-right: 4px;
        }

        /* Hover */
        .btn-claveunica:hover {
        background-color: #07305A;
        }

        /* Active */
        .btn-claveunica:active {
        background-color: rgba(0, 0, 0, 0.54);
        }

        /* Focus */
        .btn-claveunica:focus {
        outline: 4px solid rgba(255, 190, 92, 1);
        outline-offset: 2px;
        }
    </style>
<?= $this->endSection() ?>

<?= $this->section('pageContent') ?>
<div id="main-wrapper" class="auth-customizer-none">
  <div class="position-relative overflow-hidden radial-gradient min-vh-100 w-100">
    <div class="position-relative z-index-5">
      <div class="row">
        <div class="col-xl-7 col-xxl-8">
          <a href="index" class="text-nowrap logo-img d-block px-4 py-9 w-100">
            <img src="<?= base_url('assets/images/logos/logo_horizontal.png') ?>" class="dark-logo" alt="Logo-Dark" width="200"/>
            <img src="<?= base_url('assets/images/logos/logo_horizontal.png') ?>" class="light-logo" alt="Logo-light" width="200"/>
          </a>
          <div class="d-none d-xl-flex align-items-center justify-content-center h-n80">
            <img src="<?= base_url('assets/images/backgrounds/login-security.svg') ?>" alt="modernize-img" class="img-fluid" width="500">
          </div>
        </div>
        <div class="col-xl-5 col-xxl-4">
          <div class="authentication-login min-vh-100 bg-body row justify-content-center align-items-center p-4">
            <div class="auth-max-width col-sm-8 col-md-6 col-xl-7 px-4">
              <h2 class="mb-1 fs-7 fw-bolder">Bienvenido</h2>
              <p class="mb-7">Sistema de Subvenciones Municipales</p>
              <div class="row">

                <div class="col-12 mb-2 mb-sm-0">
                  <button class="btn-claveunica">
                    <img
                    type="submit" 
                    src="<?= base_url('assets/images/logos/cu-blanco.svg') ?>" alt="ClaveÚnica">ClaveÚnica</button>
                </div>
                
              </div>
              <div class="position-relative text-center my-4">
                <p class="mb-0 fs-4 px-3 d-inline-block bg-body text-dark z-index-5 position-relative">o ingresa con</p>
                <span class="border-top w-100 position-absolute top-50 start-50 translate-middle"></span>
              </div>
              <form>
                <div class="mb-3">
                  <label for="email" class="form-label">Correo electrónico</label>
                  <input type="email" class="form-control" id="email" aria-describedby="emailHelp" data-validate="required,email">
                </div>
                <div class="mb-4">
                  <label for="password" class="form-label">Contraseña</label>
                  <input type="password" class="form-control" id="password" data-validate="required">
                </div>
                <div class="d-flex align-items-center justify-content-between mb-4">
                  
                  <a class="text-primary fw-medium fs-3" href="<?=site_url('recuperar-clave')?>">¿Olvidaste tu contraseña?</a>
                </div>
                <button type="button" class="btn btn-primary w-100 py-8 mb-4 rounded-2" onclick="entrar();">Iniciar sesión</button>
                <div class="d-flex align-items-center justify-content-center">
                  <p class="fs-4 mb-0 fw-medium">¿Eres nuevo?</p>
                  <a class="text-primary fw-medium ms-2" href="#">Crea una cuenta</a>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    function entrar(){
        if (validator(["#email", "#password"])) {
            // Aquí puedes agregar la lógica para enviar el formulario o autenticar al usuario
            console.log('Formulario válido. Procediendo con la autenticación...');
            var formData = new FormData();
            formData.append('email',$('#email').val());
            formData.append('password',$('#password').val());
            loading();
            var opcionesFetch = {
                method: 'POST',
                body: formData,
            };
            var url='<?=site_url()?>login';
            
            fetch(url, opcionesFetch)
            .then(function(response) {
                return response.json();
            })
            .then(function(data) {
                if (data.success) {
                    // Add your success logic here
                    stopLoading();
                    Swal.fire({
                        icon: 'success',
                        title: 'Correcto',
                        text: data.message
                    }).then((okay) => {
                        window.location.href = '<?=site_url()?>';
                    })
                } else {
                    stopLoading();
                    Swal.fire({
                        icon: 'warning',
                        title: 'Error',
                        text: data.message
                    })
                }
            })
            .catch(function(error) {
                stopLoading();
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: error
                })
            });
        } else {
            
        }
    }
    //console.log('Hello from login page!');
</script>
<?= $this->endSection() ?>