<?= $this->extend('layouts/master-auth') ?>

<?= $this->section('title') ?>
Recuperar contraseña
<?= $this->endSection() ?>

<?= $this->section('css') ?><?= $this->endSection() ?>

<?= $this->section('pageContent') ?>
<div id="main-wrapper" class="auth-customizer-none">
  <div class="position-relative overflow-hidden radial-gradient min-vh-100 w-100">
    <div class="position-relative z-index-5">
      <div class="row">
        <div class="col-lg-6 col-xl-8">
          <a href="index" class="text-nowrap logo-img d-block px-4 py-9 w-100">
            <img src="<?= base_url('assets/images/logos/logo_horizontal.png') ?>" class="dark-logo" alt="Logo-Dark" width="200"/>
            <img src="<?= base_url('assets/images/logos/logo_horizontal.png') ?>" class="light-logo" alt="Logo-light" width="200"/>
          </a>
          <div class="d-none d-lg-flex align-items-center justify-content-center h-n80">
            <img src="<?= base_url('assets/images/backgrounds/login-security.svg') ?>" alt="modernize-img" class="img-fluid" width="500">
          </div>
        </div>
        <div class="col-lg-6 col-xl-4">
          <div class="card mb-0 shadow-none rounded-0 min-vh-100 h-100">
            <div class="auth-max-width mx-auto d-flex align-items-center w-100 h-100">
              <div class="card-body">
                <div class="mb-5">
                  <h2 class="fw-bolder fs-7 mb-3">¿Olvidaste tu contraseña?</h2>
                  <p class="mb-0 ">
                    Ingresa el email asociado a tu cuenta. Te enviaremos un enlace para restablecer tu contraseña.
                  </p>
                </div>
                <form>
                  <div class="mb-3">
                    <label for="email" class="form-label">E-mail</label>
                    <input type="email" data-validate="required,email" class="form-control" id="email" aria-describedby="emailHelp">
                  </div>
                  <a href="javascript:void(0)" onclick="recover();" class="btn btn-primary w-100 py-8 mb-3">Recuperar contraseña</a>
                  <a href="<?=site_url('login')?>" class="btn bg-primary-subtle text-primary w-100 py-8">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><g fill="none"><path fill="currentColor" d="M20 12.75a.75.75 0 0 0 0-1.5zm0-1.5H4v1.5h16z" opacity="0.5"/><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="m10 6l-6 6l6 6"/></g></svg>  
                  Volver al inicio de sesión</a>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
  function recover(){
    if(validator(['#email'])){
      var formData = new FormData();
      formData.append('email', document.getElementById('email').value);
      loading();
      var opcionesFetch = {
          method: 'POST',
          body: formData,
      };
      var url='<?=site_url('recover')?>';
      
      fetch(url, opcionesFetch)
      .then(function(response) {
          return response.json();
      })
      .then(function(data) {
          if (data.success) {
              // Add your success logic here
              stopLoading();
              Swal.fire({
                  icon: 'success',
                  title: 'Correcto',
                  text: data.message
              }).then((okay) => {
                  window.location.href = '<?=site_url('login')?>';
              })
          } else {
              stopLoading();
              Swal.fire({
                  icon: 'warning',
                  title: 'Error',
                  text: data.message
              })
          }
      })
      .catch(function(error) {
          stopLoading();
          Swal.fire({
              icon: 'error',
              title: 'Error',
              text: error
          })
      });
    }
  }
</script>
<?= $this->endSection() ?>