<?= $this->extend('layouts/master-auth') ?>

<?= $this->section('title') ?>
Recuperar contraseña
<?= $this->endSection() ?>

<?= $this->section('css') ?><?= $this->endSection() ?>

<?= $this->section('pageContent') ?>
<div id="main-wrapper" class="auth-customizer-none">
  <div class="position-relative overflow-hidden radial-gradient min-vh-100 w-100">
    <div class="position-relative z-index-5">
      <div class="row">
        <div class="col-lg-6 col-xl-8">
          <a href="index" class="text-nowrap logo-img d-block px-4 py-9 w-100">
            <img src="<?= base_url('assets/images/logos/logo_horizontal.png') ?>" class="dark-logo" alt="Logo-Dark" width="200"/>
            <img src="<?= base_url('assets/images/logos/logo_horizontal.png') ?>" class="light-logo" alt="Logo-light" width="200"/>
          </a>
          <div class="d-none d-lg-flex align-items-center justify-content-center h-n80">
            <img src="<?= base_url('assets/images/backgrounds/login-security.svg') ?>" alt="modernize-img" class="img-fluid" width="500">
          </div>
        </div>
        <div class="col-lg-6 col-xl-4">
          <div class="card mb-0 shadow-none rounded-0 min-vh-100 h-100">
            <div class="auth-max-width mx-auto d-flex align-items-center w-100 h-100">
              <div class="card-body">
                <div class="mb-5">
                  <h2 class="fw-bolder fs-7 mb-3">Cambia tu contraseña</h2>
                  <p class="mb-0 ">
                    Utiliza este formulario para cambiar tu contraseña.
                  </p>
                </div>
                <form>
                    <div class="form-group mb-3">
                        <label for="password">Contraseña</label>
                        <input type="password" id="password" data-validate="required, min-length"
                            data-min-length="6" class="form-control">
                    </div>

                    <div class="form-group mb-3">
                        <label for="password2">Repetir Contraseña</label>
                        <input type="password" id="password2"
                                data-validate="required, comparewith"
                                data-validate-compare-id="#password"
                                class="form-control">
                    </div>
                  <a href="javascript:void(0)" onclick="recover();" class="btn btn-primary w-100 py-8 mb-3">Cambiar contraseña</a>
                  <a href="<?=site_url('login')?>" class="btn bg-primary-subtle text-primary w-100 py-8">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><g fill="none"><path fill="currentColor" d="M20 12.75a.75.75 0 0 0 0-1.5zm0-1.5H4v1.5h16z" opacity="0.5"/><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="m10 6l-6 6l6 6"/></g></svg>  
                  Volver al inicio de sesión</a>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
  function recover(){
    if(validator(['#password','#password2'])){
      var formData = new FormData();
      formData.append('password', document.getElementById('password').value);
        formData.append('token', '<?=isset($token) ? $token : ''?>');
      formData.append('password2', document.getElementById('password2').value);
      loading();
      var opcionesFetch = {
          method: 'POST',
          body: formData,
      };
      var url='<?=site_url('cambiar-clave')?>';
      
      fetch(url, opcionesFetch)
      .then(function(response) {
          return response.json();
      })
      .then(function(data) {
          if (data.success) {
              // Add your success logic here
              stopLoading();
              Swal.fire({
                  icon: 'success',
                  title: 'Correcto',
                  text: data.message
              }).then((okay) => {
                  window.location.href = '<?=site_url('login')?>';
              })
          } else {
              stopLoading();
              Swal.fire({
                  icon: 'warning',
                  title: 'Error',
                  text: data.message
              })
          }
      })
      .catch(function(error) {
          stopLoading();
          Swal.fire({
              icon: 'error',
              title: 'Error',
              text: error
          })
      });
    }
  }
</script>
<?= $this->endSection() ?>