<?php
    $urlRecuperacion = site_url('validar/' . $token);
?>

<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Recuperación de Contraseña</title>

<style>
    body {
        background-color: #f5f6fa;
        margin: 0;
        padding: 0;
        font-family: 'Segoe UI', Arial, sans-serif;
        color: #333;
    }

    .email-container {
        max-width: 600px;
        margin: 40px auto;
        background: #ffffff;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }

    .header {
        background: #497c83; /* tu color institucional */
        padding: 25px;
        text-align: center;
        color: #fff;
    }

    .header h1 {
        margin: 0;
        font-size: 22px;
        letter-spacing: 1px;
    }

    .content {
        padding: 30px 40px;
        font-size: 16px;
        line-height: 1.6;
    }

    .content p {
        margin-bottom: 20px;
    }

    .btn {
        display: inline-block;
        margin-top: 25px;
        background: #497c83;
        color: #ffffff !important;
        padding: 14px 28px;
        border-radius: 6px;
        text-decoration: none;
        font-weight: bold;
        font-size: 16px;
        transition: 0.2s ease-in-out;
    }

    .btn:hover {
        background: #3a656a;
    }

    .footer {
        background: #f0f2f5;
        padding: 20px;
        font-size: 13px;
        text-align: center;
        color: #777;
    }

    .footer a {
        color: #497c83;
        text-decoration: none;
    }
</style>

</head>
<body>

<div class="email-container">

    <div class="header">
        <h1>Recuperación de Contraseña</h1>
    </div>

    <div class="content">
        <p>Hola,</p>

        <p>Hemos recibido una solicitud para restablecer tu contraseña.  
        Si fuiste tú, puedes continuar haciendo clic en el siguiente botón:</p>

        <p style="text-align:center;">
            <a href="<?= $urlRecuperacion ?>" class="btn">
                Restablecer contraseña
            </a>
        </p>

        <p>Este enlace es válido por <strong>24 horas</strong>.  
        Por tu seguridad, si tú no solicitaste el cambio, simplemente ignora este mensaje.</p>

        <p>Si el botón no funciona, copia y pega este enlace en tu navegador:</p>

        <p style="word-break: break-all; color: #497c83;">
            <a href="<?= $urlRecuperacion ?>" style="color:#497c83;">
                <?= $urlRecuperacion ?>
            </a>
        </p>
    </div>

    <div class="footer">
        Este correo fue enviado automáticamente, por favor no respondas a este mensaje.<br>
        &copy; <?= date('Y') ?> - Sistema de recuperación de acceso.
    </div>

</div>

</body>
</html>