<?= $this->extend('layouts/master') ?>

<?= $this->section('title') ?>
Mi perfil
<?= $this->endSection() ?>

<?= $this->section('css') ?><?= $this->endSection() ?>

<?= $this->section('pageContent') ?>
          <div class="card">
            <div class="card-body">
              <h5 class="card-title fw-semibold mb-4">Mi perfil</h5>
              <div class="row">
                <div class="col-md-12 mb-3">
                    <label class="form-label" for="nombre">Nombre</label>
                    <input type="text" class="form-control" name="nombre" id="nombre"
                    value="<?= $usuario['nombre'] ?>"
                        data-validate="required,min-length" data-min-length="3">
                </div>

                <div class="col-md-12 mb-3">
                    <label class="form-label" for="email">Email</label>
                    <input type="email" class="form-control" name="email" id="email"
                    value="<?= $usuario['email'] ?>"
                        data-validate="required,email">
                </div>

                <div class="col-md-12 mb-3">
                    <label class="form-label" for="password">Password</label>
                    <input type="password" class="form-control" name="password" id="password"
                        value=""
                        data-validate="min-length" data-min-length="4">
                </div>

                <div class="col-md-12 mb-3">
                    <label class="form-label" for="rut">RUT</label>
                    <input type="text" class="form-control" name="rut" id="rut"
                    value="<?= $usuario['rut'] ?>"
                        data-validate="required,rut">
                </div>

                <div class="col-md-12 mb-3">
                    <button class="btn btn-primary" onclick="save();">Guardar</button>
                </div>
            
            </div>

            </div>
          </div>
<?= $this->endSection() ?>


<?= $this->section('scripts') ?>
<script>
    function save(){
        if (validator(["#email","#nombre","#rut"])) {
            var formData = new FormData();
            formData.append('email', document.getElementById('email').value);
            formData.append('nombre', document.getElementById('nombre').value);
            formData.append('password', document.getElementById('password').value);
            formData.append('rut', document.getElementById('rut').value);
       

            loading();
            var opcionesFetch = {
                method: 'POST',
                body: formData,
            };
            var url='<?=site_url()?>mi-perfil/update';
            
            fetch(url, opcionesFetch)
            .then(function(response) {
                return response.json();
            })
            .then(function(data) {
                if (data.success) {
                    // Add your success logic here
                    stopLoading();
                    Swal.fire({
                        icon: 'success',
                        title: 'Correcto',
                        text: data.message
                    });
                } else {
                    stopLoading();
                    Swal.fire({
                        icon: 'warning',
                        title: 'Error',
                        text: data.message
                    })
                }
            })
            .catch(function(error) {
                stopLoading();
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: error
                })
            });
        }
    }
</script>
<?= $this->endSection() ?>