<?= $this->extend('layouts/master') ?>

<?= $this->section('title') ?>
Permisos de perfiles
<?= $this->endSection() ?>

<?= $this->section('pageContent') ?>

<div class="card">
    <div class="card-body">
        <h5 class="card-title fw-semibold mb-4">
            Permisos de perfiles
        </h5>
        <table class="table">
            <thead class="table-light">
                <tr>
                    <th>Nombre del perfil</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                    foreach ($perfiles as $key => $perfil) {
                        ?>
                        <tr>
                            <td><?= $perfil["nombre"] ?></td>
                            <td>
                                <?php 
                                    if (permiso('Permisos','Asignar')) {
                                        ?>
                                         <a href="<?= site_url('permisos/perfil/'.$perfil['id']) ?>" class="btn btn-primary btn-sm">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 12h16m0 0l-6-6m6 6l-6 6"/></svg>    
                                Configurar permisos</a>
                                        <?php
                                    }else{
                                        ?>-<?php
                                    }
                                ?>
                               
                            </td>
                        </tr>
                        <?php
                    }
                ?>
            </tbody>    

           
        </table>
        
    </div>
</div>

<?= $this->endSection() ?>
