<?= $this->extend('layouts/master') ?>

<?= $this->section('title') ?>
Crear Usuario
<?= $this->endSection() ?>

<?= $this->section('pageContent') ?>
<div class="card">
    <div class="card-body">
        <h5 class="card-title fw-semibold mb-4">Crear Usuario</h5>

        <div class="row">
            <div class="col-md-12 mb-3">
                <label class="form-label" for="nombre">Nombre</label>
                <input type="text" class="form-control" name="nombre" id="nombre"
                    data-validate="required,min-length" data-min-length="3">
            </div>

            <div class="col-md-12 mb-3">
                <label class="form-label" for="email">Email</label>
                <input type="email" class="form-control" name="email" id="email"
                    data-validate="required,email">
            </div>

            <div class="col-md-12 mb-3">
                <label class="form-label" for="password">Password</label>
                <input type="password" class="form-control" name="password" id="password"
                    data-validate="required,min-length" data-min-length="4">
            </div>

            <div class="col-md-12 mb-3">
                <label class="form-label" for="rut">RUT</label>
                <input type="text" class="form-control" name="rut" id="rut"
                    data-validate="required,rut">
            </div>

            <div class="col-md-12 mb-3">
                <label class="form-label" for="perfil_id">Perfil</label>
                <select type="text" class="form-control" name="perfil_id" id="perfil_id"
                    data-validate="required">
                    <option value="" selected disabled>Seleccione…</option>
                    <?php 
                        foreach ($perfiles as $key => $perfil) {
                            ?>
                            <option value="<?=$perfil["id"] ?>"><?=$perfil["nombre"]?></option>
                            <?php
                        }
                    ?>
                </select>
            </div>

            <div class="col-md-12 mb-3">
                <label class="form-label" for="activo">Activo</label>
                <select class="form-select" name="activo" id="activo" 
                        data-validate="required">
                    <option value="" selected disabled>Seleccione…</option>
                    <option value="1">Sí</option>
                    <option value="0">No</option>
                </select>
            </div>
            <div class="col-md-12 mb-3">
                 <button class="btn btn-primary" onclick="save();">Guardar</button>
            </div>
           
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    function save(){
        if (validator(["#email","#nombre","#password","#rut","#activo","#perfil_id"])) {
            var formData = new FormData();
            formData.append('email', document.getElementById('email').value);
            formData.append('nombre', document.getElementById('nombre').value);
            formData.append('password', document.getElementById('password').value);
            formData.append('rut', document.getElementById('rut').value);
            formData.append('perfil_id', document.getElementById('perfil_id').value);
            formData.append('activo', document.getElementById('activo').value);

            loading();
            var opcionesFetch = {
                method: 'POST',
                body: formData,
            };
            var url='<?=site_url()?>usuario/store';
            
            fetch(url, opcionesFetch)
            .then(function(response) {
                return response.json();
            })
            .then(function(data) {
                if (data.success) {
                    // Add your success logic here
                    stopLoading();
                    Swal.fire({
                        icon: 'success',
                        title: 'Correcto',
                        text: data.message
                    }).then((okay) => {
                        window.location.href = '<?= site_url('usuario') ?>';
                    })
                } else {
                    stopLoading();
                    Swal.fire({
                        icon: 'warning',
                        title: 'Error',
                        text: data.message
                    })
                }
            })
            .catch(function(error) {
                stopLoading();
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: error
                })
            });
        }
    }
</script>
<?= $this->endSection() ?>